unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, OpenGL, MyGLInit, FileBVH, MotionBlending, ExtCtrls, XPMan,
  Buttons, CgTypes, CgGeometry, Math;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    XPManifest1: TXPManifest;
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    Timer2: TTimer;
    Button2: TButton;
    Button4: TButton;
    Button1: TButton;
    GroupBox2: TGroupBox;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Button11: TButton;
    ColorDialog1: TColorDialog;
    Button13: TButton;
    Button14: TButton;
    Button16: TButton;
    Image1: TImage;
    Label1: TLabel;
    GroupBox3: TGroupBox;
    Button18: TButton;
    Button19: TButton;
    Button20: TButton;
    Button21: TButton;
    Button22: TButton;
    Button23: TButton;
    Button24: TButton;
    Label6: TLabel;
    GroupBox4: TGroupBox;
    Button15: TButton;
    GroupBox5: TGroupBox;
    Button17: TButton;
    Button12: TButton;
    Button3: TButton;
    Label4: TLabel;
    Edit1: TEdit;
    Label5: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    Button26: TButton;
    Button25: TButton;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormResize(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RadioButton2Click(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button5MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button5MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button8MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button8MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button6MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button6MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button7MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button7MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure Button16Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
    procedure Button18Click(Sender: TObject);
    procedure Button19Click(Sender: TObject);
    procedure Button20Click(Sender: TObject);
    procedure Button21Click(Sender: TObject);
    procedure Button22Click(Sender: TObject);
    procedure Button23Click(Sender: TObject);
    procedure Button24Click(Sender: TObject);
    procedure Button25Click(Sender: TObject);
    procedure Button26Click(Sender: TObject);
  private
    procedure Draw;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

var
  base:GLuint;
  subor, file1, file2, file3:TextFile;
  point_size:real=1.0;
  x,z,uhol1,uhol2,uhol:Single;
  mysX,mysY,m,n,hlbka,vyska:Integer;
  bsplajn,translate,play,mouse,pokus,hore,dole,vlavo,vpravo:Boolean;
  sec_to_fir,fir_to_sec,grid,LinInt,PC_display,new_PC,rotate:Boolean;
  skeleton:array of TSkeleton;
  skeleton_result:TSkeleton;
  filename:array of string;
  actual:byte; //actual skeleton
  blending:TBlending;
  t,x0,z0,weight:real;
  w:array of real;   // array of point weights
  matrix:TCGMatrix;
//  PCD_creation:array[0..1] of boolean;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FullScreenForm(640,320,32,Form1);
  GLInit(handle);
  glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
  glDisable(GL_BLEND);
  glEnable(GL_COLOR_MATERIAL);
  glEnable(GL_LIGHTING);

  base:=vytvorFont('Courier New',10);

  Edit1.Text:='200';
  Edit2.Text:='35';
  uhol:=1;
  Image1.Canvas.Create;

  setlength(skeleton,2);
  setlength(filename,2);
  actual:=0;

//  PCD_creation[0]:=false;
//  PCD_creation[1]:=false;
  bsplajn:=false;
  sec_to_fir:=false;
  fir_to_sec:=false;
  translate:=false;
  play:=true;
  mouse:=false;
  pokus:=false;
  rotate:=false;
  new_PC:=false;
  PC_display:=false;
  hore:=false;
  dole:=false;
  vlavo:=false;
  vpravo:=false;
  LinInt:=false;
  x:=0.0;
  z:=-126.0;
  hlbka:=-100;
  vyska:=0;
  grid:=true;
  m:=3;
  n:=3;
  weight:=0.5;

  blending:=TBlending.Create;

  AssignFile(subor,'subor.txt');
  Rewrite(subor);

end;

procedure TForm1.Draw;
var i:integer;
begin
  glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
  glLoadIdentity;
  glTranslatef(x,0.0,z);
  svetlo(x,0.0,-32.0+z,1.0);
  glRotatef(-uhol1,0.0,1.0,0.0);
  glRotatef(-uhol2,1.0,0.0,0.0);
  point_size:=3;
  glPointSize(point_size);
  material_color(0,1,1,1);

  for i:=0 to high(skeleton) do
    if skeleton[i] <> nil then
      skeleton[i].z_viewport:=z;

  for i:=0 to high(skeleton) do
  begin
    if skeleton[i] <> nil then
      with skeleton[i] do

        if i <> actual then

          if not LinInt then
            display(actual_frame,255,0,0,play)
          else
            LI_display(actual_frame+0.5,255,0,0)

        else

          if not LinInt then
            display(actual_frame,0,0,255,play)
          else
            LI_display(actual_frame+0.5,0,0,255);

  end;
//displays grid
  if grid then
  begin
    material_color(255,255,255,1);
    glBegin(GL_LINES);
    for i:=-10 to 10 do
    begin
      glVertex3f(i*5,vyska,-50);
      glVertex3f(i*5,vyska,50);
    end;
    glEnd();

    glBegin(GL_LINES);
    for i:=-10 to 10 do
    begin
      glVertex3f(-50,vyska,i*5);
      glVertex3f(50,vyska,i*5);
    end;
    glEnd();
  end;

//draws point cloud
  if PC_display and (skeleton[actual]<>nil) and (skeleton[actual].pointcloud) then
  begin
    glPointSize(15);
    glBegin(GL_POINTS);
    material_color(1,1,1,0);
    with skeleton[actual] do
      for i:=0 to ((high(animation.PCD[actual_frame])-2) div 3) do
        glVertex3f(animation.PCD[actual_frame][i*3],animation.PCD[actual_frame][i*3+1],animation.PCD[actual_frame][i*3+2]);

    glEnd();
  end;

  //draws 5 x PC
  if new_PC then
  begin
    if blending.PC[0] <> nil then
      blending.PC[0].display(0,255,0);
    if blending.PC[1] <> nil then
    begin
      if rotate then
      begin
        glTranslatef(x0,0,z0);
        glRotatef(t,0.0,1.0,0.0);
        blending.PC[1].display(255,0,0);
        glRotatef(-t,0.0,1.0,0.0);
        glTranslatef(-x0,0,-z0);
      end else
        blending.PC[1].display(255,0,0);
    end;
  end;

  SwapBuffers(wglGetCurrentDC);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if vlavo then begin
    uhol1:=uhol1+1.5 ;
    x:=trans_poz(1.5,x,z).x;
    z:=trans_poz(1.5,x,z).y;
  end;
  if vpravo then begin
    uhol1:=uhol1-1.5 ;
    x:=trans_poz(-1.5,x,z).x;
    z:=trans_poz(-1.5,x,z).y;
  end;
  if hore then z:=z+2;
  if dole then z:=z-2;

  form1.Caption:=FloatToStr(sqrt(x*x+z*z))+';x:'+FloatToStr(x)+';z:'+FloatToStr(z);

  Draw;
end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if mouse then
  begin
    mysX:=X;
    mysY:=Y;
  end;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  glViewport(0,0,Width,Height);    //pri zmene velkosti Formu
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if mouse then
    if Shift=[ssleft] then
    begin
      uhol1:=(mysX-X);
      uhol2:=(mysY-Y);
    end;
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
  case Key of
    'u':inc(vyska);
    'd':dec(vyska);
  end;
end;

procedure TForm1.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
   VK_LEFT:vlavo:=false;
   VK_RIGHT:vpravo:=false;
   VK_UP:hore:=false;
   VK_DOWN:dole:=false;
   VK_ESCAPE: begin FullScreenForm(0,0,0,Form1); close; end;
 end;

end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 case Key of
   VK_LEFT:vlavo:=true;
   VK_RIGHT:vpravo:=true;
   VK_UP:hore:=true;
   VK_DOWN:dole:=true;
 end;
end;

procedure TForm1.RadioButton2Click(Sender: TObject);
begin
  actual:=1;
end;

procedure TForm1.RadioButton1Click(Sender: TObject);
begin
  actual:=0;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then            { Display Open dialog box }
    filename[0]:=OpenDialog1.FileName; { File selected in dialog }
    skeleton[0]:=TSkeleton.Create(filename[0]);
    RadioButton1.Enabled:=true;
{  x:=0.0;
  z:=-126.0;
  mysX:=0;
  mysY:=0;
  uhol1:=0;
  uhol2:=0;
  uhol:=1;
}
//  Image1.Height:=length(skeleton[0].animation.frames);
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  if OpenDialog1.Execute then            { Display Open dialog box }
    filename[1]:=OpenDialog1.FileName; { File selected in dialog }
    skeleton[1]:=TSkeleton.Create(filename[1]);
    RadioButton2.Enabled:=true;
{  x:=0.0;
  z:=-126.0;
  mysX:=0;
  mysY:=0;
  uhol1:=0;
  uhol2:=0;
  uhol:=1;
}//  Image1.Width:=length(skeleton[1].animation.frames);
end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
  LinInt:=false;
  with skeleton[actual] do
  begin
    inc(actual_frame);
    Label1.Caption:='Actual frame = '+IntToStr(actual_frame);

    PC_already:=false;
    setlength(pom,0);

    if actual_frame = frames_count then
      actual_frame:=0;
  end;
end;

procedure TForm1.BitBtn6Click(Sender: TObject);
begin
  LinInt:=false;
  with skeleton[actual] do
  begin
    dec(actual_frame);
    Label1.Caption:='Actual frame = '+IntToStr(actual_frame);

    PC_already:=false;
    setlength(pom,0);

    if actual_frame = -1 then
      actual_frame:= frames_count-1;
  end;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  Timer2.Interval:=round(skeleton[actual].frame_time*1000);
  Timer2.Enabled:=true;
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
  Timer2.Enabled:=false;
end;

procedure TForm1.Timer2Timer(Sender: TObject);
begin
  if play then
    with skeleton[actual] do
    begin
      inc(actual_frame);
      Label1.Caption:='Actual frame = '+IntToStr(actual_frame);
//      Setlength(animation.PCD[actual_frame],joints_count*3);

      PC_already:=false;
      setlength(pom,0);

      if actual_frame = frames_count then
        actual_frame:=0;

    end
  else
  begin //pripad, ked sa automaticky prehraju obe animacie
    if (not pokus) then
    begin
      with skeleton[actual] do
      begin
        inc(actual_frame);
        Label1.Caption:='Actual frame = '+IntToStr(actual_frame);
        Setlength(animation.PCD[actual_frame],joints_count*3);

        PC_already:=false;
        setlength(pom,0);

        if actual_frame = frames_count then
        actual_frame:=0;

        if animation.PCD[frames_count-1] <> nil then
        begin
          RadioButton2.Checked:=true;
          pokus:=true;
Timer2.Interval:=round(skeleton[actual].frame_time*1000);
        end;
    //      BitBtn4.Click;
      end;
    end
    else
    with skeleton[actual] do
    begin
      inc(actual_frame);
      Label1.Caption:='Actual frame = '+IntToStr(actual_frame);
      Setlength(animation.PCD[actual_frame],joints_count*3);

      PC_already:=false;
      setlength(pom,0);

      if actual_frame = frames_count then
        actual_frame:=0;

      if animation.PCD[frames_count-1] <> nil then
      begin
        mouse:=true;
        play:=true;
        Button12.Enabled:=true;
        Button25.Enabled:=true;
        BitBtn3.Visible:=true;
        BitBtn4.Visible:=true;
        BitBtn5.Visible:=true;
        BitBtn6.Visible:=true;
        BitBtn4.Click;
      end;
//      Timer2.Enabled:=false;
    end;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var i,j:smallint;
begin
  PC_display:=not PC_display;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  grid:= not(grid);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  LinInt:=true;
end;

procedure TForm1.Button1Click(Sender: TObject);
var i:smallint;
    j,count:word;
begin
  count:=0;

  with blending do
    with skeleton[actual] do
    begin
      PC[actual]:=TPointCloud.Create(actual_frame);
      PC[actual].jpf:=joints_count;
      setlength(PC[actual].data,neigh_frames*PC[actual].jpf*3);
      //create pointcloud data
      for i:=PC[actual].id_frame-(neigh_frames div 2) to PC[actual].id_frame+(neigh_frames div 2) do
        for j:=0 to PC[actual].jpf*3-1 do
        begin
          PC[actual].data[count]:=animation.PCD[i][j];
          inc(count);
        end;
    end;
  new_PC:=not new_PC;
end;

procedure TForm1.Button5MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  hore:=true;
end;

procedure TForm1.Button5MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  hore:=false;
end;

procedure TForm1.Button8MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  dole:=true;
end;

procedure TForm1.Button8MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  dole:=false;
end;

procedure TForm1.Button6MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  vlavo:=true;
end;

procedure TForm1.Button6MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  vlavo:=false;
end;

procedure TForm1.Button7MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  vpravo:=true;
end;

procedure TForm1.Button7MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  vpravo:=false;
end;

procedure TForm1.Button9Click(Sender: TObject);
var i:word;
    x1,x2,z1,z2:array of real;
begin
  with blending do
  begin
    setlength(w,length(PC[0].data) div 3);
    for i:=0 to high(w) do
      w[i]:=1/length(w);
    setlength(x1,length(w));
    setlength(x2,length(w));
    setlength(z1,length(w));
    setlength(z2,length(w));

    for i:=0 to high(x1) do
      x1[i]:=PC[0].data[i*3];

    for i:=0 to high(z1) do
      z1[i]:=PC[0].data[i*3+2];

    for i:=0 to high(x2) do
      x2[i]:=PC[1].data[i*3];

    for i:=0 to high(z2) do
      z2[i]:=PC[1].data[i*3+2];

    t:=Tau(w,x1,z1,x2,z2);
    x0:=X_0(w, x1, x2, z2, t);
    z0:=Z_0(w, x2, z1, z2, t);
    rotate:=true;

    Showmessage('x0 : '+FloatToStr(x0)+'; z0 : '+FloatToStr(z0)+'; tau : '+FloatToStr(t));
  end;
end;

procedure TForm1.Button10Click(Sender: TObject);
begin
  with blending do
    Showmessage('Vzdialenost frejmov je '+FloatToStr(CIDF(w,t,x0,z0,PC[0],PC[1])));
end;

procedure TForm1.Button12Click(Sender: TObject);
var i,j,k,n,count:word;
    x1,x2,z1,z2:array of real;
    delta_weight,distance,max,min,mult:real;
    int:integer;
    grey:byte;
////Timewarp
    pole:array of char;
    p,pom:integer;
    b_time,e_time:TDateTime;
//////RC_Result
    frame_count,help_count,unblended_count:integer;
    help_frame:TFrame;
    first:boolean;
    m:integer;
    help_array:array of TFrame;
/////Bsplajn
    vertices:array of TBod;
    mm,nn,opak:integer;
    tt:array of real;
    X,Y,z,delta:real;
    i_help_frame,j_help_frame:TFrame;

  function Nf(k,i:integer; te:real):real;
  var koef1,koef2,men1,men2:real;
  begin
    if (i>=0) and (i<mm) and (k=0) then
    begin
      if (te>=tt[i]) and (te<tt[i+1]) then
        Result:=1;
      if (te<tt[i]) or (te>=tt[i+1]) then
        Result:=0;
    end;

    if (k>0) and (k<=opak) and (i>=0) and (i<mm-k) then
    begin
      men1:=tt[i+k]-tt[i];
      men2:=tt[i+k+1]-tt[i+1];
      if men1=0 then koef1:=0 else
        koef1:=(te-tt[i])/men1;
      if men2=0 then koef2:=0 else
        koef2:=(tt[i+k+1]-te)/men2;

      Result:=koef1*Nf(k-1,i,te)+koef2*Nf(k-1,i+1,te);
    end;
  end;

  function Alfa(j,i:integer;te:real):real;
  begin
    if tt[i+opak-j+1]<>tt[i] then
     Result:=(te-tt[i])/(tt[i+opak-j+1]-tt[i])
     else Result:=0;
  end;

begin
 if (skeleton[0]<>nil) and (skeleton[1]<>nil) then
  if skeleton[0].joints_count = skeleton[1].joints_count then
  begin

  b_time:=Time;
 //playing of both animations with generating of pointclouds

  Label6.Caption:='Computing 0%';
  Label6.Refresh;
  Draw;

  max:=0;
  min:=500000;

  Image1.Height:=length(skeleton[0].animation.frames);
  Image1.Width:=length(skeleton[1].animation.frames);

  with blending do
  begin
   setlength(table,length(skeleton[1].animation.frames));
   for i:=0 to high(table) do
     setlength(table[i],length(skeleton[0].animation.frames));

   for n:=2 to high(skeleton[1].animation.frames)-{2}3 do
    for k:=2 to high(skeleton[0].animation.frames)-2 do
    begin
      if (n = round(high(skeleton[1].animation.frames)/2)) and (k = 2)then
      begin
        Label6.Caption:='Computing 20%';
        Label6.Refresh;
        Draw;
      end;

      count:=0;
      PC[0].Free;
      PC[1].Free;
      with skeleton[0] do
      begin
        PC[0]:=TPointCloud.Create(k);
        PC[0].jpf:=joints_count;
        setlength(PC[0].data,neigh_frames*PC[0].jpf*3);
        //create pointcloud data
        for i:=PC[0].id_frame-(neigh_frames div 2) to PC[0].id_frame+(neigh_frames div 2) do
          for j:=0 to PC[0].jpf*3-1 do
          begin
            PC[0].data[count]:=animation.PCD[i][j];
            inc(count);
          end;
      end;
/////////////////skeleton[1] -> 2-nd pointcloud
      count:=0;
      with skeleton[1] do
      begin
        PC[1]:=TPointCloud.Create(n{2});
        PC[1].jpf:=joints_count;
        setlength(PC[1].data,neigh_frames*PC[1].jpf*3);
        //create pointcloud data
        for i:=PC[1].id_frame-(neigh_frames div 2) to PC[1].id_frame+(neigh_frames div 2) do
          for j:=0 to PC[1].jpf*3-1 do
          begin
            PC[1].data[count]:=animation.PCD[i][j];
            inc(count);
          end;
      end;

///////////////

      setlength(w,length(PC[0].data) div 3);
      for i:=0 to high(w) do
        w[i]:=1/length(w);
      setlength(x1,length(w));
      setlength(x2,length(w));
      setlength(z1,length(w));
      setlength(z2,length(w));

      for i:=0 to high(x1) do
        x1[i]:=PC[0].data[i*3];

      for i:=0 to high(z1) do
        z1[i]:=PC[0].data[i*3+2];

      for i:=0 to high(x2) do
        x2[i]:=PC[1].data[i*3];

      for i:=0 to high(z2) do
        z2[i]:=PC[1].data[i*3+2];

      t:=Tau(w,x1,z1,x2,z2);
      x0:=X_0(w, x1, x2, z2, t);
      z0:=Z_0(w, x2, z1, z2, t);
///////////////////
      distance:=CIDF(w,t,x0,z0,PC[0],PC[1]);
//we get max value
      if distance > max then max:=round(distance);

{      if (distance<0) then distance:=0;
      if distance>100 then
        distance:=100;
}//     Image1.Canvas.Pixels[n,k]:=RGB(round(distance*mult{/15}){-33},round(distance*mult{/15}){-33},round(distance*mult{/15}){-33});    //todoooooooooooooooooooooo
      table[n,k]:=round(distance{*mult});
      Write(subor,IntToStr(round(distance))+' ');

    end;
//  Showmessage('Maximum = '+FloatToStr(max));
  mult:={2.5}max/255;

   for n:=2 to high(skeleton[1].animation.frames)-{2}3 do
    for k:=2 to high(skeleton[0].animation.frames)-2 do
    begin
//      table[n,k]:=round(table[n,k]/mult);
      grey:=round(table[n,k]/mult);
      Image1.Canvas.Pixels[n,k]:=RGB(grey,grey,grey{round(distance*mult),round(distance*mult),round(distance*mult)});    //todoooooooooooooooooooooo
    end;

  Image1.Picture.SaveToFile('grid.bmp');
  CloseFile(subor);

  Label6.Caption:='Computing 40%';
  Label6.Refresh;
  Draw;

  ///////////////
// initialization of DP
//  threshold:=50/100;
  area:=StrToInt(Edit2.Text)/100{0.35}*max;
  setlength(DP,length(skeleton[1].animation.frames));
  for i:=0 to high(DP) do
    setlength(DP[i],length(skeleton[0].animation.frames));
  for i:=0 to high(DP) do
    for j:=0 to high(DP[i]) do
      DP[i][j]:=TCell.Create(1000000);
 end;
///////////Timewarp

{  pom:=150;
  if skeleton[0].frames_count <= skeleton[1].frames_count then
  begin
    if skeleton[0].frames_count < 150 then
      pom:=skeleton[0].frames_count;
  end
  else
    if skeleton[1].frames_count < 150 then
      pom:=skeleton[1].frames_count;
}

  with blending do
  begin
    min:=10000;
    for p:=2 to {pom}round(skeleton[0].frames_count*0.3) do
      if table[2,p] < min then
      begin
        i:=2;
        j:=p;
        min:=table[2,p];
      end;

    for p:=2 to {pom}round(skeleton[1].frames_count*0.3) do
      if table[p,2] < min then
      begin
        i:=p;
        j:=2;
        min:=table[p,2];
      end;

    riesenie:=TCell.Create(1000000);
    j_max:=high(skeleton[0].animation.frames)-2;
    i_max:=high(skeleton[1].animation.frames)-2;
    zac_ries_i:=i;
    zac_ries_j:=j;

    Label6.Caption:='Computing 50%';
    Label6.Refresh;
    Draw;

    Timewarp(i,j,'z',2,2,0,nil);

    Label6.Caption:='Computing 80%';
    Label6.Refresh;
    Draw;

    if riesenie.cost=1000000 then
    begin
      Showmessage('Optimal path has not been found, input motions are not blendable');
      halt;
    end;

//setlength(blending.riesenie.direction,length(blending.riesenie.direction)-1);

    Image1.Picture.LoadFromFile('grid.bmp');

    Image1.Canvas.Pixels[i,j]:=RGB(0,0,255);

    with riesenie do
    begin
      for p:=1 to high(direction) do
      begin
        case direction[p] of
          'd':begin
                inc(j);
                Image1.Canvas.Pixels[i,j]:=RGB(255,0,0);

              end;
          'r':begin
                inc(i);
                Image1.Canvas.Pixels[i,j]:=RGB(255,0,0);
              end;
          's':begin
                inc(i);
                inc(j);
                Image1.Canvas.Pixels[i,j]:=RGB(255,0,0);
              end;
        end;
      end;
    end;
  end;
  Image1.Picture.SaveToFile('grid.bmp');

//////////////////////////////////////////////////////////////////////////////////////////B-splajn
if bsplajn then
begin
  i:=blending.zac_ries_i;
  j:=blending.zac_ries_j;
  setlength(vertices,2);                   //we get vertices for a B-spline
  vertices[0]:=TBod.Create(i,j,-1);
  vertices[1]:=TBod.Create(i,j,-1);

  with blending.riesenie do
  begin
    for p:=1 to high(direction) do
    begin
      setlength(vertices,length(vertices)+1);
      vertices[high(vertices)]:=TBod.Create(i,j,-1);
      case direction[p] of
        'd':begin
              inc(j);
            end;
        'r':begin
              inc(i);
            end;
        's':begin
              inc(i);
              inc(j);
            end;
      end;
    end;
    setlength(vertices,length(vertices)+2);
    vertices[high(vertices)-1]:=TBod.Create(i,j,-1);
    vertices[high(vertices)]:=TBod.Create(i,j,-1);
  end;

  if length(vertices)>0 then
    nn:=high(vertices)
  else
    nn:=0;

  opak:=3;                 //degree of Bspline is 3
  mm:=nn+opak+1;
  //zadanie uzloveho vektora
  setlength(tt,mm+1);
  for i:=0 to mm do
    tt[i]:=i;

  //vypocet krivky
{  i:=blending.zac_ries_i;
  j:=blending.zac_ries_j;
}  skeleton_result:=TSkeleton.Create(filename[0]);

  with skeleton_result do
  begin

    frames_count:=StrToInt(Edit1.Text)+1;
    animation.Destroy;
    animation:=TAnimation.Create('resulting motion');
    setlength(animation.frames,frames_count);

    if translate then
    begin
      delta:=1/(frames_count-1);
      weight:=0;
    end
    else
    begin
      delta:=0;
      weight:=0.5;
    end;

    if (length(vertices)>1) and (tt[nn+1]>tt[opak]) then
    begin
      for j:=0 to frames_count-1 do
      begin
        X:=0;Y:=0;
        for i:=0 to nn do
        begin
          z:=Nf(opak,i,tt[opak]+j/(frames_count+1)*(tt[nn+1]-tt[opak]));
          X:=X+vertices[i].X*z;
          Y:=Y+vertices[i].Y*z;
        end;
        i_help_frame:=TFrame.Create(skeleton[1].animation.frames[round(X)],skeleton[1].animation.frames[round(X)+1],1-X+round(X));
        j_help_frame:=TFrame.Create(skeleton[0].animation.frames[round(Y)],skeleton[0].animation.frames[round(Y)+1],1-Y+round(Y));
        animation.frames[j]:=TFrame.Create(i_help_frame,j_help_frame,weight);
        weight:=weight+delta;
      end;
    end;
    Save('RC_Result.bvh');
  end;
end;

/////////////////RC_Result
if not bsplajn then
begin
  i:=2;
  j:=2;
  i:=blending.zac_ries_i;
  j:=blending.zac_ries_j;
  help_frame:=TFrame.Create;

  m:=1;

// pokus o 'delete' v skeletone[1]
  with skeleton[1] do
  with blending.riesenie do
  begin
    while m <= high(direction) do
    begin
      case direction[m] of
        'd':inc(j);
        'r':inc(i);
        's':begin
              inc(i);
              inc(j);
            end;
      end;

      if direction[m] = 'r' then
        if direction[m+1] = 'r' then
          if direction[m+2] = 'r' then
          begin
            help_frame.Destroy;
            direction[m]:='n';
            direction[m+1]:='n';
            direction[m+2]:='n';
            help_frame:=TFrame.Create(animation.frames[i],animation.frames[i+3],0.5);
            animation.frames[i]:=nil;
            animation.frames[i+1]:=nil;
            animation.frames[i+2]:=nil;

            animation.frames[i+3].Destroy;
            animation.frames[i+3]:=TFrame.Create;
            setlength(animation.frames[i+3].data, length(help_frame.data));
            for n:=0 to high(help_frame.data) do
              animation.frames[i+3].data[n]:=help_frame.data[n];
            i:=i+2;
            m:=m+2;
          end
          else
          begin
            help_frame.Destroy;
            direction[m]:='n';
            direction[m+1]:='n';
            help_frame:=TFrame.Create(animation.frames[i],animation.frames[i+2],0.5);
            animation.frames[i]:=nil;
            animation.frames[i+1]:=nil;

            animation.frames[i+2].Destroy;
            animation.frames[i+2]:=TFrame.Create;
            setlength(animation.frames[i+2].data, length(help_frame.data));

            for n:=0 to high(help_frame.data) do
              animation.frames[i+2].data[n]:=help_frame.data[n];

            i:=i+1;
            m:=m+1;
          end
        else
        begin
          help_frame.Destroy;
          direction[m]:='n';
          help_frame:=TFrame.Create(animation.frames[i],animation.frames[i+1],0.5);
          animation.frames[i]:=nil;

            animation.frames[i+1].Destroy;
            animation.frames[i+1]:=TFrame.Create;
            setlength(animation.frames[i+1].data, length(help_frame.data));
            for n:=0 to high(help_frame.data) do
              animation.frames[i+1].data[n]:=help_frame.data[n];
        end;
      inc(m);
    end;
  end;

  //kontrola ci tam uz nie je 'r'
  setlength(pole,0);
  for m:=0 to high(blending.riesenie.direction) do
    if blending.riesenie.direction[m] = 'r' then Showmessage('Je tam este r');
//Showmessage('Koniec kontroly r');
////////////////////////////////////////////////////////////////////////////////
// pokus o 'insert' v skeletone[1]

  i:=blending.zac_ries_i;
  j:=blending.zac_ries_j;
  help_frame.Destroy;
  help_frame:=TFrame.Create;
  setlength(help_array,0);

  m:=1;

  with skeleton[1] do
  with blending.riesenie do
  begin
    while m <= high(direction) do
    begin
      case direction[m] of
        'd':inc(j);
        'n':inc(i);
        's':begin
              inc(i);
              inc(j);
            end;
      end;

      if direction[m] = 'd' then
        if direction[m+1] = 'd' then
        begin
            direction[m]:='m';
            direction[m+1]:='m';

            help_frame:=TFrame.Create(animation.frames[i],animation.frames[i+1],0.33); //vytvorim prvy medziframe
            setlength(help_array,length(help_array)+1);
            help_array[high(help_array)]:=TFrame.Create;
            setlength(help_array[high(help_array)].data, length(help_frame.data));
            for n:=0 to high(help_frame.data) do                                     //pridam medziframe do pola
              help_array[high(help_array)].data[n]:=help_frame.data[n];
//Showmessage('Pridany dalsi frame');

            help_frame.Destroy;
            help_frame:=TFrame.Create(animation.frames[i],animation.frames[i+1],0.66); //vytvorim druhy medziframe
            setlength(help_array,length(help_array)+1);
            help_array[high(help_array)]:=TFrame.Create;
            setlength(help_array[high(help_array)].data, length(help_frame.data));
            for n:=0 to high(help_frame.data) do                                     //pridam medziframe do pola
              help_array[high(help_array)].data[n]:=help_frame.data[n];
//Showmessage('Pridany dalsi frame');
            j:=j+1;
            m:=m+1;
        end
        else
        begin
          help_frame.Destroy;
          direction[m]:='m';

          help_frame:=TFrame.Create(animation.frames[i],animation.frames[i+1],0.5);   //vytvorim medziframe medzi i a i+1
          setlength(help_array,length(help_array)+1);
          help_array[high(help_array)]:=TFrame.Create;
          setlength(help_array[high(help_array)].data, length(help_frame.data));
          for n:=0 to high(help_frame.data) do                                     //pridam medziframe do pola
            help_array[high(help_array)].data[n]:=help_frame.data[n];
//Showmessage('Pridany dalsi frame');
        end;
      inc(m);
    end;
  end;

//Showmessage('Dlzka help pola je '+IntToStr(length(help_array)));
  //kontrola ci tam uz nie je 'd'
  setlength(pole,0);
  for m:=0 to high(blending.riesenie.direction) do
    if blending.riesenie.direction[m] = 'd' then Showmessage('Je tam este d');
//Showmessage('Koniec kontroly d');

////////////////////////////////////////////////////////////////////////////////

  i:=blending.zac_ries_i;
  j:=blending.zac_ries_j;
  help_count:=0;
  skeleton_result:=TSkeleton.Create(filename[0]);

  with skeleton_result do
  begin
    animation.Destroy;
    animation:=TAnimation.Create('resulting motion');
    setlength(animation.frames,0);
    with blending.riesenie do
    begin

      frames_count:=0;
      for p:=1 to high(direction)-1 do
        if (direction[p]='m') or (direction[p]='s') then
          inc(frames_count);
      if translate and sec_to_fir then
        weight:=0;
      if translate and fir_to_sec then
        weight:=1;
//      unblended_count:=round(frames_count/5);
        delta_weight:=1/(frames_count-1);
//delta_weight:=1/(frames_count-1-2*unblended_count);

      for p:=1 to high(direction)-1 do
      begin
        case direction[p] of
          'm':begin
                inc(j);
                if (skeleton[0].animation.frames[j] <> nil) and ({skeleton[1].animation.frames[i]}help_array[help_count] <> nil) then
                begin
                  setlength(animation.frames,length(animation.frames)+1);
                  animation.frames[high(animation.frames)]:=TFrame.Create(skeleton[0].animation.frames[j],help_array[help_count]{skeleton[1].animation.frames[i]},weight);
                  inc(help_count);
                  if (translate) and (sec_to_fir) {and (length(animation.frames) > unblended_count) and (length(animation.frames) < (frames_count-unblended_count))} then
                    weight:=weight+delta_weight;
                  if translate and fir_to_sec then
                    weight:=weight-delta_weight;
                end
                else
                  if skeleton[0].animation.frames[j] <> nil then
                    Showmessage(IntTostr(i)+' '+IntTostr(j)+' chyba je v skeletone 1')
                  else
                    Showmessage(IntTostr(i)+' '+IntTostr(j)+' chyba je v skeletone 0');
              end;
          'n':inc(i);
          's':begin
                inc(i);
                inc(j);
                if (skeleton[0].animation.frames[j] <> nil) and (skeleton[1].animation.frames[i] <> nil) then
                begin
                  setlength(animation.frames,length(animation.frames)+1);
                  animation.frames[high(animation.frames)]:=TFrame.Create(skeleton[0].animation.frames[j],skeleton[1].animation.frames[i],weight);
                  if translate and sec_to_fir {and (length(animation.frames) > unblended_count) and (length(animation.frames) < (frames_count-unblended_count))} then
                    weight:=weight+delta_weight;
                  if translate and fir_to_sec then
                    weight:=weight-delta_weight;
                end
                else
                  if skeleton[0].animation.frames[j] <> nil then
                    Showmessage(IntTostr(i)+' '+IntTostr(j)+' chyba je v skeletone 1')
                  else
                    Showmessage(IntTostr(i)+' '+IntTostr(j)+' chyba je v skeletone 0');
              end;
        end;
      end;
    end;
    frames_count:=length(animation.frames);
    Save('RC_Result.bvh');
  end;
end;

  Label6.Caption:='Computing 100%';
  Label6.Refresh;
  Draw;

  e_time:=Time;
  Showmessage('Elapsed time : '+TimeToStr(e_time-b_time)+' and the name of the blended motion is RC_Result');
  Label6.Visible:=false;
 end
 else Showmessage('Different number of joints in skeletons, load another please.')
else Showmessage('Firstly, both motions must be loaded');

end;

procedure TForm1.Button13Click(Sender: TObject);
var pole:array of char;
    p,i,j:integer;
    n,k:word;
    b_time,e_time:TDateTime;
    min:real;
begin
  with blending do
  begin
    min:=10000;
    for p:=2 to 100 do
    begin
      if table[2,p] < min then
      begin
        i:=2;
        j:=p;
        min:=table[2,p];
      end;
      if table[p,2] < min then
      begin
        i:=p;
        j:=2;
        min:=table[p,2];
      end;
    end;

    riesenie:=TCell.Create(1000000);
    j_max:=high(skeleton[0].animation.frames)-2;
    i_max:=high(skeleton[1].animation.frames)-2;
    zac_ries_i:=i;
    zac_ries_j:=j;
//    Showmessage('area je '+FloatToStr(area));
    b_time:=Time;
    Timewarp(i,j,'z',2,2,0,nil);
    e_time:=Time;
    Image1.Picture.LoadFromFile('grid.bmp');

    Image1.Canvas.Pixels[i,j]:=RGB(0,0,255);

    with riesenie do
    begin
      for p:=1 to high(direction) do
      begin
        case direction[p] of
          'd':begin
                inc(j);
                Image1.Canvas.Pixels[i,j]:=RGB(255,0,0);

              end;
          'r':begin
                inc(i);
                Image1.Canvas.Pixels[i,j]:=RGB(255,0,0);
              end;
          's':begin
                inc(i);
                inc(j);
                Image1.Canvas.Pixels[i,j]:=RGB(255,0,0);
              end;
        end;
      end;
    end;
  end;
  Image1.Picture.SaveToFile('grid.bmp');
  Showmessage('Timewarping trval : '+TimeToStr(e_time-b_time)+' a cena cesty je '+FloatToStr(blending.riesenie.cost));

//  Button6.Enabled:=true;
//  Button7.Enabled:=true;
end;

procedure TForm1.Button14Click(Sender: TObject);
begin
  skeleton[actual].Save('Result.bvh');
end;

procedure TForm1.Button15Click(Sender: TObject);
var i,frame_count:integer;
    f:TFrame;
    first:boolean;
    weight,delta:real;
    b_time,e_time:TDateTime;
begin
 if (skeleton[0]<>nil) and (skeleton[1]<>nil) then
 begin
  b_time:=Time;
  if skeleton[0].frames_count < skeleton[1].frames_count then
  begin
    frame_count:=skeleton[0].frames_count;
    skeleton_result:=TSkeleton.Create(filename[0]);
    first:=true;
  end
  else
  begin
    frame_count:=skeleton[1].frames_count;
    skeleton_result:=TSkeleton.Create(filename[1]);
    first:=false;
  end;

  with skeleton_result do
  begin
    animation.Destroy;
    animation:=TAnimation.Create('resulting motion');
    setlength(animation.frames,frame_count);
    if not translate then
    begin
//      weight:=0.5;
      if first then
        for i:=0 to frame_count-1 do
          animation.frames[i]:=TFrame.Create(skeleton[0].animation.frames[i],skeleton[1].animation.frames[i],weight)
      else
        for i:=0 to frame_count-1 do
          animation.frames[i]:=TFrame.Create(skeleton[1].animation.frames[i],skeleton[0].animation.frames[i],weight);
    end
    else
    begin
      weight:=0;
      delta:=1/(frame_count-1);
      if first then
        for i:=0 to frame_count-1 do
        begin
          animation.frames[i]:=TFrame.Create(skeleton[0].animation.frames[i],skeleton[1].animation.frames[i],weight);
          weight:=weight+delta;
        end
      else
        for i:=0 to frame_count-1 do
        begin
          animation.frames[i]:=TFrame.Create(skeleton[1].animation.frames[i],skeleton[0].animation.frames[i],weight);
          weight:=weight+delta;
        end;
    end;
    e_time:=Time;
    Showmessage('Elapsed time : '+TimeToStr(e_time-b_time)+' and the name of the blended motion is LI_Result');
    Save('LI_Result.bvh');
  end;

  Bitbtn3.Visible:=true;
  Bitbtn4.Visible:=true;
  Bitbtn5.Visible:=true;
  Bitbtn6.Visible:=true;
  mouse:=true;
  play:=true;
 end
 else
  Showmessage('Firstly, you must load both animations');
end;

procedure TForm1.Button16Click(Sender: TObject);
var frame_count:integer;
    help_frame:TFrame;
    first:boolean;
    weight:real;
    p,i,j,m,n:integer;
    pole:array of char;
begin
  i:=2;
  j:=2;
  i:=blending.zac_ries_i;
  j:=blending.zac_ries_j;
  help_frame:=TFrame.Create;

  m:=1;
  weight:=0.5;

// pokus o 'delete' v skeletone[1]
  with skeleton[1] do
  with blending.riesenie do
  begin
    while m <= high(direction) do
    begin
      case direction[m] of
        'd':inc(j);
        'r':inc(i);
        's':begin
              inc(i);
              inc(j);
            end;
      end;

      if direction[m] = 'r' then
        if direction[m+1] = 'r' then
          if direction[m+2] = 'r' then
          begin
            help_frame.Destroy;
            direction[m]:='n';
            direction[m+1]:='n';
            direction[m+2]:='n';
            help_frame:=TFrame.Create(animation.frames[i],animation.frames[i+3],0.5);
            animation.frames[i]:=nil;
            animation.frames[i+1]:=nil;
            animation.frames[i+2]:=nil;

            animation.frames[i+3].Destroy;
            animation.frames[i+3]:=TFrame.Create;
            setlength(animation.frames[i+3].data, length(help_frame.data));
            for n:=0 to high(help_frame.data) do
              animation.frames[i+3].data[n]:=help_frame.data[n];
            i:=i+2;
            m:=m+2;
          end
          else
          begin
            help_frame.Destroy;
            direction[m]:='n';
            direction[m+1]:='n';
            help_frame:=TFrame.Create(animation.frames[i],animation.frames[i+2],0.5);
            animation.frames[i]:=nil;
            animation.frames[i+1]:=nil;

            animation.frames[i+2].Destroy;
            animation.frames[i+2]:=TFrame.Create;
            setlength(animation.frames[i+2].data, length(help_frame.data));

            for n:=0 to high(help_frame.data) do
              animation.frames[i+2].data[n]:=help_frame.data[n];

            i:=i+1;
            m:=m+1;
          end
        else
        begin
          help_frame.Destroy;
          direction[m]:='n';
          help_frame:=TFrame.Create(animation.frames[i],animation.frames[i+1],0.5);
          animation.frames[i]:=nil;

            animation.frames[i+1].Destroy;
            animation.frames[i+1]:=TFrame.Create;
            setlength(animation.frames[i+1].data, length(help_frame.data));
            for n:=0 to high(help_frame.data) do
              animation.frames[i+1].data[n]:=help_frame.data[n];
        end;
      inc(m);
    end;
  end;

  //kontrola ci tam uz nie je 'r'
  setlength(pole,0);
  for m:=0 to high(blending.riesenie.direction) do
    if blending.riesenie.direction[m] = 'r' then Showmessage('Je tam este r');

Showmessage('Hotovo2');

  i:=blending.zac_ries_i;
  j:=blending.zac_ries_j;

  skeleton_result:=TSkeleton.Create(filename[0]);

  with skeleton_result do
  begin
    animation.Destroy;
    animation:=TAnimation.Create('resulting motion');
    setlength(animation.frames,0);
    with blending.riesenie do
      for p:=1 to high(direction)-1 do
      begin
        case direction[p] of
          'd':begin
                inc(j);
                if (skeleton[0].animation.frames[j] <> nil) and (skeleton[1].animation.frames[i] <> nil) then
                begin
                  setlength(animation.frames,length(animation.frames)+1);
                  animation.frames[high(animation.frames)]:=TFrame.Create(skeleton[0].animation.frames[j],skeleton[1].animation.frames[i],weight);
                end
                else
                  if skeleton[0].animation.frames[j] <> nil then
                    Showmessage(IntTostr(i)+' '+IntTostr(j)+' chyba je v skeletone 1')
                  else
                    Showmessage(IntTostr(i)+' '+IntTostr(j)+' chyba je v skeletone 0');
              end;
          'n':inc(i);
          's':begin
                inc(i);
                inc(j);
                if (skeleton[0].animation.frames[j] <> nil) and (skeleton[1].animation.frames[i] <> nil) then
                begin
                  setlength(animation.frames,length(animation.frames)+1);
                  animation.frames[high(animation.frames)]:=TFrame.Create(skeleton[0].animation.frames[j],skeleton[1].animation.frames[i],weight);
                end
                else
                  if skeleton[0].animation.frames[j] <> nil then
                    Showmessage(IntTostr(i)+' '+IntTostr(j)+' chyba je v skeletone 1')
                  else
                    Showmessage(IntTostr(i)+' '+IntTostr(j)+' chyba je v skeletone 0');
              end;
        end;
      end;
    frames_count:=length(animation.frames);
    Save('RC_Result.bvh');
  end;
end;

procedure TForm1.Button17Click(Sender: TObject);
begin
 if (skeleton[0]<>nil) and (skeleton[1]<>nil) then
  if skeleton[0].joints_count = skeleton[0].joints_count then
  begin
    skeleton[0].actual_frame:=0;
    skeleton[1].actual_frame:=0;
    play:=false;
    RadioButton1.Checked:=true;
    Timer2.Interval:=round(skeleton[actual].frame_time*1000);
    Timer2.Enabled:=true;
  end
  else
   Showmessage('Load another motions, these are not similar')
 else
  Showmessage('Firstly, you must load both animations');   
// actual:=0;
// BitBtn3.Click;
// PCD_creation[0]:=true;

//  RadioButton2.Checked:=true;
//  Timer2.Interval:=round(skeleton[actual].frame_time*1000);
{  Timer2.Interval:=1;
  Timer2.Enabled:=true;
}// actual:=1;
// BitBtn3.Click;

end;

procedure TForm1.Button18Click(Sender: TObject);
begin
  weight:=0.9;
  translate:=false;
  Label2.Caption:='Actual weights : 10%';
end;

procedure TForm1.Button19Click(Sender: TObject);
begin
  weight:=0.7;
  translate:=false;
  Label2.Caption:='Actual weights : 30%';
end;

procedure TForm1.Button20Click(Sender: TObject);
begin
  weight:=0.5;
  translate:=false;
  Label2.Caption:='Actual weights : 50%';
end;

procedure TForm1.Button21Click(Sender: TObject);
begin
  weight:=0.3;
  translate:=false;
  Label2.Caption:='Actual weights : 70%';
end;

procedure TForm1.Button22Click(Sender: TObject);
begin
  weight:=0.1;
  translate:=false;
  Label2.Caption:='Actual weights : 90%';
end;

procedure TForm1.Button23Click(Sender: TObject);
begin
  translate:=true;
  fir_to_sec:=true;
  sec_to_fir:=false;
  Label2.Caption:='Actual weights : translation 1 --> 2';
end;

procedure TForm1.Button24Click(Sender: TObject);
begin
  translate:=true;
  sec_to_fir:=true;
  fir_to_sec:=false;
  Label2.Caption:='Actual weights : translation 1 --> 2'{naopak};
end;

procedure TForm1.Button25Click(Sender: TObject);
begin
  bsplajn:=not bsplajn;
  Label3.Caption:='Path type : B-spline';

  Edit1.Visible:=true;
  Label4.Visible:=true;
//  Label3.Visible:=not Label3.Visible;
end;

procedure TForm1.Button26Click(Sender: TObject);
begin
  bsplajn:=not bsplajn;

  Edit1.Visible:=false;
  Label4.Visible:=false;
  Label3.Caption:='Path type : discreet';
end;

end.
